%--------------------------------------------------------------------------
% im_thin_clean_br
% pre-processing helper function
% (c) 2015-2016 Andrew R. Cohen, Walter Mankowski and Rohini Joshi
%
%
%       This is the source code for the paper:

%  R. Joshi, W. Mankowski, M. Winter, J. S. Saini, T. A. Blenkinsop, J. H. Stern, S. Temple and 
%       A. R. Cohen, "Automated measurement of cobblestone morphology for 
%       characterizing Stem cell-Derived Retinal Pigment Epithelial cell cultures".
%
%     This is free software: you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 3 of the License, or
%     (at your option) any later version.
% 
%     The software is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
% 
%     You should have received a copy of the GNU General Public License
%     in file "gnu gpl v3.txt". If not, see <http://www.gnu.org/licenses/>.
%
% EXCEPTION: as described in the paper, the source code for the steerable 
%   wavelet filters must be downloaded separately from http://bigwww.epfl.ch/demo/circular-wavelets. 
%   All use of that component is governed by the license agreement described there.
% 
% Andrew Cohen
% acohen 'at' coe.drexel.edu
% http://bioimage.coe.drexel.edu
%
%--------------------------------------------------------------------------
function [im_thin_clean_br, im_thin_clean] = rpe_morph_open(img)
level = graythresh(img);
img_bw = im2bw(img, level);
im_skel = bwmorph(img_bw, 'skel', Inf);

im_thin = bwmorph(img_bw, 'thin', Inf);

im_thin_clean = bwmorph(im_thin, 'clean');

im_thin_clean_br = bwmorph(im_thin_clean,'branchpoints');
