classdef (Abstract,Sealed) Cuda
methods (Static)
    [imageOut] = WienerFilter(imageIn,kernel,noiseVariance,device)
    [imageOut] = VarFilter(imageIn,kernel,numIterations,device)
    [imageOut] = StdFilter(imageIn,kernel,numIterations,device)
    [imageOut] = Opener(imageIn,kernel,numIterations,device)
    [imageOut] = MedianFilter(imageIn,kernel,numIterations,device)
    [imageOut] = HighPassFilter(imageIn,sigmas,device)
    [imageOut] = Sum(imageIn,device)
    [imageOut] = NLMeans(imageIn,h,searchWindowRadius,nhoodRadius,device)
    [minVal,maxVal] = GetMinMax(imageIn,device)
    [imageOut] = MeanFilter(imageIn,kernel,numIterations,device)
    [imageOut] = EntropyFilter(imageIn,kernel,device)
    [imageOut] = MaxFilter(imageIn,kernel,numIterations,device)
    [imageOut] = ElementWiseDifference(image1In,image2In,device)
    [imageOut] = LoG(imageIn,sigmas,device)
    [imageOut] = Closure(imageIn,kernel,numIterations,device)
    [imageOut] = MultiplySum(imageIn,kernel,numIterations,device)
    [imageOut] = Gaussian(imageIn,sigmas,numIterations,device)
    [hydraConfig] = CheckConfig()
    [imageOut] = IdentityFilter(imageIn,device)
    [deviceStatsArray] = DeviceStats()
    [imageOut] = MinFilter(imageIn,kernel,numIterations,device)
    [numCudaDevices,memStats] = DeviceCount()
    [cmdInfo] = Info()
    Help(command)
end
methods (Static, Access = private)
    varargout = HIP(command, varargin)
end
end
