// This file is used to register commands that are callable via script languages
SCR_BEGIN_COMMANDS
	/////////////////
	// SCRIPT_COMMAND_DEF:
	// Add new wrapped commands here
	/////////////////
	// SCR_CMD(Name, Params, CudaFunc) -
	//   Autogenerates script command `Name` info based on parameters,
	//   automatically creates typed stub functions that call `CudaFunc`
	//   in CudaImageProcessing project.
	//   NOTE: the ScriptCommand_`Name` class must be created in a header with a help
	//     string definition. For examples see ScrCmd*.h files.
	/////////////////
	// SCR_CMD_NOPROC(Name, Params)
	//   Autogenerated script command `Name` info based on parameters,
	//   no automatic cuda calls are made.
	//   NOTE: the ScriptCommand_`Name` class must be created in a header with a help
	//     string definition as well as an execute or process<OutT,InT> function definition.
	/////////////////

	// These are default commands defined for all script wrappers.
	SCR_CMD_NOPROC(Help, SCR_PARAMS(SCR_OPTIONAL(SCR_SCALAR(std::string), command, "")))
	SCR_CMD_NOPROC(Info, SCR_PARAMS(SCR_OUTPUT(SCR_STRUCT, cmdInfo)))
	SCR_CMD_NOPROC(DeviceCount, SCR_PARAMS(SCR_OUTPUT(SCR_SCALAR(int32_t), numCudaDevices),
												SCR_OUTPUT(SCR_STRUCT, memStats)))
	SCR_CMD_NOPROC(DeviceStats, SCR_PARAMS(SCR_OUTPUT(SCR_STRUCT, deviceStatsArray)))

	SCR_CMD(Closure, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cClosure
	)

	SCR_CMD(ElementWiseDifference, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), image1In),
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), image2In),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cElementWiseDifference
	)

	SCR_CMD(EntropyFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cEntropyFilter
	)

	SCR_CMD(Gaussian, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_VECTOR(double), sigmas),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cGaussian
	)

	SCR_CMD(GetMinMax, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_SCALAR(SCR_DYNAMIC), minVal),
			SCR_OUTPUT(SCR_SCALAR(SCR_DYNAMIC), maxVal),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cGetMinMax
	)

	SCR_CMD(HighPassFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_VECTOR(double), sigmas),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cHighPassFilter
	)

	SCR_CMD(IdentityFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cIdentityFilter
	)

	SCR_CMD(LoG, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_VECTOR(double), sigmas),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cLoG
	)


	SCR_CMD(MaxFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cMaxFilter
	)

	SCR_CMD(MeanFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cMeanFilter
	)

	SCR_CMD(MedianFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cMedianFilter
	)

	SCR_CMD(MinFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cMinFilter
	)

	SCR_CMD(MultiplySum, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cMultiplySum
	)

	SCR_CMD(NLMeans, SCR_PARAMS
	(
		SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
		SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
		SCR_INPUT(SCR_SCALAR(double), h),
		SCR_OPTIONAL(SCR_SCALAR(double), searchWindowRadius,10),
		SCR_OPTIONAL(SCR_SCALAR(double), nhoodRadius,2),
		SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
	),
		cNLMeans
	)

	SCR_CMD(Opener, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cOpener
	)

	SCR_CMD(StdFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cStdFilter
	)

	SCR_CMD(Sum, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_SCALAR(SCR_DYNAMIC), imageOut),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cSum
	)

	SCR_CMD(VarFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(int), numIterations, 1),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cVarFilter
	)

	SCR_CMD(WienerFilter, SCR_PARAMS
		(
			SCR_INPUT(SCR_IMAGE(SCR_DYNAMIC), imageIn),
			SCR_OUTPUT(SCR_IMAGE(SCR_DYNAMIC), imageOut),
			SCR_INPUT(SCR_IMAGE_CONVERT(float), kernel),
			SCR_OPTIONAL(SCR_SCALAR(double), noiseVariance, -1.0),
			SCR_OPTIONAL(SCR_SCALAR(int), device, -1)
		),
		cWienerFilter
	)


	/////////////////

SCR_END_COMMANDS
