classdef (Abstract,Sealed) Cuda
methods (Static)
    Help(command)
    [cmdInfo] = Info()
    [numCudaDevices,memStats] = DeviceCount()
    [deviceStatsArray] = DeviceStats()
    [imageOut] = ElementWiseDifference(image1In,image2In,device)
    [imageOut] = EntropyFilter(imageIn,kernel,device)
    [imageOut] = HighPassFilter(imageIn,sigmas,device)
    [imageOut] = Gaussian(imageIn,sigmas,numIterations,device)
    [imageOut] = Closure(imageIn,kernel,numIterations,device)
    [minVal,maxVal] = GetMinMax(imageIn,device)
    [imageOut] = WienerFilter(imageIn,kernel,noiseVariance,device)
    [imageOut] = Opener(imageIn,kernel,numIterations,device)
    [imageOut] = IdentityFilter(imageIn,device)
    [imageOut] = MultiplySum(imageIn,kernel,numIterations,device)
    [imageOut] = LoG(imageIn,sigmas,device)
    [imageOut] = StdFilter(imageIn,kernel,numIterations,device)
    [imageOut] = MeanFilter(imageIn,kernel,numIterations,device)
    [imageOut] = MedianFilter(imageIn,kernel,numIterations,device)
    [imageOut] = MinFilter(imageIn,kernel,numIterations,device)
    [imageOut] = MaxFilter(imageIn,kernel,numIterations,device)
    [imageOut] = NLMeans(imageIn,h,searchWindowRadius,nhoodRadius,device)
    [imageOut] = Sum(imageIn,device)
    [imageOut] = VarFilter(imageIn,kernel,numIterations,device)
end
methods (Static, Access = private)
    varargout = Mex(command, varargin)
end
end
