%
% goStats
% script to read in results from ellipse simulation and display. 
% also exports results to excel
%
% NOTE - you need to have run goEllipseSimulate first, and point this
% script at the output folder from that.
%
rgRatio=[];
rgLabels=[];
for k=2:5
    fname=['.\Experiment\Experiment1\' num2str(k) '.mat'];
    load(fname);
    
    rgRatio=[rgRatio;1-[rgExperiment.scorePR]'];
    rgRatio=[rgRatio;1-[rgExperiment.scoreGMM]'];
    rgRatio=[rgRatio;1-[rgExperiment.scoreWF]'];
    rgRatio=[rgRatio;1-[rgExperiment.scoreSW]'];
    
    label=0;
    
    rgLabels=[rgLabels;repmat(label,length([rgExperiment.scorePR]),1)];
    rgLabels=[rgLabels;repmat(label+1,length([rgExperiment.scorePR]),1)];
    rgLabels=[rgLabels;repmat(label+2,length([rgExperiment.scorePR]),1)];
    rgLabels=[rgLabels;repmat(label+3,length([rgExperiment.scorePR]),1)];
    
end


idx=isnan(rgRatio)|isinf(rgRatio);
rgRatio(idx)=[];
rgLabels(idx)=[];

hold off
plot([-10 100],[1 1],'linestyle','--','color',[.8,.8,.8],'linewidth',.75)
hold on
boxplot(rgRatio,rgLabels,'notch','on')
text={};
text{end+1}=['PR'];
text{end+1}=['GM'];
text{end+1}=['WF'];
text{end+1}=['SW'];
set(gca,'xticklabel',text)

% for export to Excel
exMed = [];
exCI = [];
dataX=[];
for i=1:3
    
    idx = find(rgLabels==i-1);
    dataX(:,i)=rgRatio(idx);
    % conf interval = q2 + 1.57(q3  q1)/sqrt(n)
    q2 = median(rgRatio(idx));
    q3 = prctile(rgRatio(idx),75);
    q1 = prctile(rgRatio(idx),25);
    
    exCI(i) = 1.57*(q3-q1)/sqrt(length(idx));
    exMed(i)=q2;
end

A=[];
for i=1:4
    idxi=find(rgLabels==i-1);
    A(:,i)=[ mean(rgRatio(idxi));std(rgRatio(idxi))/(2*sqrt(length(idxi)))];
end
xlswrite('ellipseSim.xls',A)

% paired rank sum test
signrank(rgRatio(find(rgLabels==0)),rgRatio(find(rgLabels==3)))
% non-paired test
ranksum(rgRatio(find(rgLabels==0)),rgRatio(find(rgLabels==3)))
