%
% goEllipseSimulate
% main entry point for performance characterization of different object
% partitioning algorithms on synthetic ellipse data
%
warning off all

ExperimentID='Experiment1'
if ~exist('.\Experiment','dir')
    mkdir('.\Experiment');
end
if ~exist(['.\Experiment\' ExperimentID] ,'dir')
    mkdir(['.\Experiment\' ExperimentID] );
end

outMAT = ['.\Experiment\' ExperimentID '\'];

mu1=[500,500];
p = gcp('nocreate'); % If no pool, do not create new one.
if isempty(p)
    parpool(40);
end

spmd
    % turn off convergence warnings
    warning('off','all')
end

tStart=datetime

for K=2:5
    
    rgExperiment=[];
    
    scorePR=[];
    scoreGMM=[];
    scoreWF=[];
    % colors = [colors;hsv(250)];
    
    parfor n=1:1000
        % switch these two lines to turn on/off parallelization
%         for n=1:1000
        tic
        bValidEllipse=0;
        while ~bValidEllipse
            pts={};
            ptsEdge={};
            
            for kk=1:K
                [pts{kk} ptsEdge{kk}] = GetRandomEllipse(mu1);
            end
            
            % place each ellipse
            for kk=2:K
                ptsCombined=vertcat(pts{1:kk-1});
                idxK = 1+round((length(pts{kk})-1)*rand());
                idxCombined = 1+round((length(ptsCombined)-1)*rand());
                offset = ptsCombined(idxCombined,:)-pts{kk}(idxK,:);
                pts{kk} = pts{kk} + repmat(offset,[size(pts{kk},1) 1]);
                ptsEdge{kk} = ptsEdge{kk}+repmat(offset,[size(ptsEdge{kk},1) 1]);
            end
            idxPts={};
            for kk=1:K
                idxPts{kk}=sub2ind([1000,1000],pts{kk}(:,2),pts{kk}(:,1));
            end
            
            idxPtsOverlap=GetOverlap(idxPts);
            % make sure no ellipse is fully contained in another
            nNonOverlap=idxPtsOverlap(2.^[0:K-1]);
            nNonOverlap=cellfun(@length,nNonOverlap);
            if all(nNonOverlap~=0)
                bValidEllipse=1;
            end
            
        end
        % all the ellipses together
        ptsCombined=vertcat(pts{:}); 
        % Pixel Rep
        ptsReplicated = PixelReplicate(ptsCombined);        
        objPR=fitgmdist(ptsReplicated,K,'replicates',20);
        scorePR = ScoreClustering(objPR,idxPtsOverlap,pts);
        % GMM
        objGMM=fitgmdist(ptsCombined,K,'replicates',20);
        scoreGMM=ScoreClustering(objGMM,idxPtsOverlap,pts);
        % WF
        [bwd bw] = DepthImageFromPoints(ptsCombined);
        bwd = -bwd;
        bwd(~bw)=-Inf;
        L = Waterfall(bwd, K);
        L=L';
        scoreWF=ScoreClustering(L,idxPtsOverlap,pts);
        % seeded WF
        seedPts = objPR.mu;
        L=SeededWatershed(bw',seedPts);
        scoreSW = ScoreClustering(L,idxPtsOverlap,pts);
       
        rgExperiment(n).n=n;
        rgExperiment(n).scoreGMM=scoreGMM;
        rgExperiment(n).scorePR=scorePR;
        rgExperiment(n).pts=pts;
        rgExperiment(n).ptsEdge=ptsEdge;
        rgExperiment(n).idxPtsOverlap=idxPtsOverlap;
        rgExperiment(n).scoreWF = scoreWF;
        rgExperiment(n).K=K;
        rgExperiment(n).objGMM=objGMM;
        rgExperiment(n).objPR=objPR;
        rgExperiment(n).scoreSW=scoreSW;
        ElapsedTime=toc;
        fprintf(1,'%d(k=%d): wf=%2.2f gmm=%2.2f, pr = %2.2f, sw = %2.2f time = %f\n',n,K,scoreWF,scoreGMM,scorePR,scoreSW,ElapsedTime);
        
    end
    
    save([outMAT num2str(K) '.mat'],'rgExperiment');
end
tEnd=datetime