
%
% genEllipse
% return the ellipse with center mu, covariance cv and isocontour c
%
function [pts, bw]=genEllipse(mu,cv,c,bFill)

if nargin<3
    c=1;
end

if nargin<4
    bFill=1;
end
bw=false(1000);
    
theta=linspace(0,2*pi,1000);
[evec, eval]=eig(cv);
[eval order] = sort(diag(eval),'descend');
evec=evec(:,order);

a1 = sqrt(eval(1))*c*evec(:,1);
a2 = sqrt(eval(end))*c*evec(:,2);

x = (mu(1) + a1(1)*sin(theta) + a2(1)*cos(theta));
y = (mu(2) + a1(2)*sin(theta) + a2(2)*cos(theta));
x = max(x, 1);
y = max(y, 1);
x = min(x, 1000);
y = min(y, 1000);

pts=[x' y'];
idx=sub2ind(size(bw),round(y),round(x));
bw(idx)=1;

if bFill
    bw = imfill(bw,'holes');
    [r c]=find(bw);
    pts=[c r];
end