
%
% SeededWatershed
%   forces watershed basins at the seedPts locations
%
function L = SeededWatershed(bwIm, seedPts)
    bwSeed = false(size(bwIm));
    idxSeed = sub2ind(size(bwIm),round(seedPts(:,2)),round(seedPts(:,1)));
    bwSeed(idxSeed) = true;
    
    D = bwdist(bwSeed);
    D(~bwIm) = -Inf;
    
    L = watershed(D);
    
    % Assign border (or dropped) pixels to their nearest component
    bBorder = (L==0) | (bwIm & L==1);
    [~,tstIdx] = bwdist(L > 1);
    L(bBorder) = L(tstIdx(bBorder));
    
    L = remapLabels(L);
end

function L = remapLabels(inL)
    allLabels = unique(inL);
    
    remapIdx = zeros(1,max(allLabels));
    remapIdx(allLabels) = [0 1:length(allLabels)-1];
    
    L = remapIdx(inL);
end
