function score = ScoreClustering(objL,idxPtsOverlap,pts,bDraw)

if nargin<4
    bDraw=0;
end
sz = [1000,1000];

if all(size(objL)==sz)
    L=objL;
    obj=[];
else
    L=[];
    obj=objL;
end

K=log2(length(idxPtsOverlap)+1);

idxCluster={};
for kk=1:length(idxPtsOverlap)
    
    if ~isempty(L)
        idxCluster{kk}=L(idxPtsOverlap{kk});
    else
        [r c]=ind2sub(sz,idxPtsOverlap{kk});
        if isempty(r)
            idxCluster{kk}=[];
            continue
        end
        idxCluster{kk}=obj.cluster([c,r]);
    end
end

% try every different cluster label combo - choose the best
idxPerms = perms(1:K);
rgCorrect=[];
for n=1:size(idxPerms,1)
    % idxPerms(n,:) is the current key
    rgCorrect(n)=0;
    for kk=1:length(idxPtsOverlap)
        rgBinary=de2bi(kk);
        idx1=find(rgBinary);
        % these are the ok labels for this bin for this perm
        okLabels = idxPerms(n,idx1);
        for i=1:length(okLabels)
            rgCorrect(n)=rgCorrect(n)+length(find(idxCluster{kk}==okLabels(i)));
        end
    end
end


[score, idxPermMax]=max(rgCorrect);
% unique number of non-overlapping points
nElements = cellfun(@length,idxPtsOverlap);
nElements=sum(nElements(:));

% this is the unbalanced estimate. instead we use the balanced error rate 
% (see below)
% score = score/nElements;

nWrong = zeros(length(idxPtsOverlap),1);
score=0;
nRegions = cellfun(@length,idxPtsOverlap);
% subtract one for the one overlap region with all pixels - that one can't
% have any errors in it...
nRegions=length(find(nRegions))-1;
% circle the wrong ones
for kk=1:length(idxPtsOverlap)
    if length(idxPtsOverlap{kk})==0
        continue
    end

    rgBinary=de2bi(kk);
    idx1=find(rgBinary);
    
    % these are the ok labels for the best perm
    okLabels = idxPerms(idxPermMax,idx1);
    idxWrong=idxCluster{kk};
    for j=1:length(okLabels)
        idxCheck = find([idxWrong]==okLabels(j));
        idxWrong(idxCheck)=0;
        
    end
    idxWrong=find(idxWrong);
    if (bDraw)
        [r, c]=ind2sub(sz,idxPtsOverlap{kk});
        plot(c(idxWrong),r(idxWrong),'xk')
        plot(c(idxWrong),r(idxWrong),'ok')
    end
    nWrong(kk)=length(idxWrong);
    score = score + length(idxWrong)/length(idxPtsOverlap{kk}) * 1/nRegions;

end

score=zeros(K,1);
% now combine nWrong from error bins back to original ellipses
for kk=1:length(idxPtsOverlap)-1
    rgBinary=de2bi(kk);
    idx1=find(rgBinary);
    % these are ellipses that these points belong to
    
    for i=1:length(idx1)
        score(idx1(i))=score(idx1(i))+nWrong(kk);
    end
    
end

% now balance the score
for kk=1:K
    
    nPoints = length(pts{kk})-length(idxPtsOverlap{end});
    score(kk)=score(kk)/nPoints;
end

score=mean(score);
%convert to accuracy
score = 1 - score;
4;
