%
% PixelReplicate
% does the pixel replication step
% pts - (x,y) coordinates of foreground pixels (1 component only!)
%
function ptsReplicate = PixelReplicate(pts)


bwd=DepthImageFromPoints(pts);

ptsReplicate=zeros(sum(round(bwd(:))),2);
% ptsReplicate=[];
idx=find(bwd);
nInsert=1;
for i=1:length(idx)
    [r c]=ind2sub(size(bwd),idx(i));
    nrep = round(bwd(idx(i)));
    % speed up by using pre-allocated ptsReplicate
    ptsReplicate(nInsert:nInsert+nrep-1,:) = repmat([r,c],nrep,1);
    %    ptsReplicate = [ptsReplicate;repmat([r,c],nrep,1)];
    nInsert=nInsert+nrep;
end

