%
% GetRandomEllipse
% generates a random ellipse at location mu
%
function [pts ptsEdge] = GetRandomEllipse(mu)


r1 = 10+20*rand();
r2 = 10+20*rand();

theta = 2*pi*rand();

cv = [r1^2 0;0 r2^2];

[pts]=genEllipse(mu,cv);
ptsEdge = genEllipse(mu,cv,1,0);

pts=pts-repmat(mu,[size(pts,1) 1]);
ptsEdge = ptsEdge-repmat(mu,[size(ptsEdge,1) 1]);
rotate = [cos(theta) -sin(theta);sin(theta) cos(theta)];

pts=pts*rotate;
ptsEdge=ptsEdge*rotate;

pts=pts+repmat(mu,[size(pts,1) 1]);
ptsEdge=ptsEdge+repmat(mu,[size(ptsEdge,1) 1]);

bw=false(1000);
idx=sub2ind(size(bw),round(ptsEdge(:,2)),round(ptsEdge(:,1)));

bw(idx)=1;

bw = imfill(bw,'holes');
[r c]=find(bw);
pts=[c r];
