% 
% GetOverlap
%  takes foreground pts (1-d) idxPts
%   computes map of number of points in each region 
%   idxPtsOverlap goes from 1..2^K-1
%       the index is a binary vector specifying the overlap regions,
%       e.g. 1,2,4,8, etc are points only in ellipses 1,2,3,4 etc.
%       3 is in 1 and 2, 5 is in 4 and 1, etc.
%
function idxPtsOverlap=GetOverlap(idxPts)

K=length(idxPts);
idxPtsOverlap={};
% no overlap between superset and subset pixels
for n=1:(2^K)-1
    rgBinary=de2bi(n);
    idx1 = find(rgBinary);
    if length(idx1)==1
        idxPtsOverlap{n}=idxPts{idx1};
        continue
    end
    nIntersect=idxPts{idx1(1)};
    for i=2:length(idx1)
        nIntersect=intersect(nIntersect,idxPts{idx1(i)});
    end
    idxPtsOverlap{n}=nIntersect;
end

for i=1:length(idxPtsOverlap)
    for j=1:length(idxPtsOverlap);
        if i==j
            continue
        end
        rgBinaryI = de2bi(i);
        rgBinaryJ = de2bi(j);
        
        if length(find(rgBinaryI))<length(find(rgBinaryJ))
            idxPtsOverlap{i}=setdiff(idxPtsOverlap{i},idxPtsOverlap{j});
        end
    end
end
