# PixelRep_Demo is the MAIN demo file. Run this file to simulate Pixel Rep.

# -------------------------------------------------------------------------------
# Copyright (c) 2016, Drexel University
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of PixelRep nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# -------------------------------------------------------------------------------

import PIXEL_REPLICATION_LIB as PR
import GENERATE_ELLIPSE_LIB as GenEllipse

# Generate random ellipse image
print("Generating Ellipse...")
K = 4 # number of ellipse to fit
bwim, trueEdges = GenEllipse.GetRandomEllipseImage(K)

# # You may import an image for demo by uncommenting the following code:
# import cv2
# im = cv2.imread('U:\Angeline\PixelRep\Ellipse_k4.tif', cv2.CV_8UC1)
# th, bwim = cv2.threshold(im, 0, 1, cv2.THRESH_BINARY)
# trueEdges = [0, 0] # keep as [0, 0] if true edges are unknown.
#                    # Include (r, c) array of boundary pixels if known
# # (Remember to modify K number of ellipses)

# IMPORTANT NOTE:
# bwim only has 1 connected component. if bwim has multiple connected
# components, process each one separately

ptsRep = PR.PixelReplicate(bwim)

# Fit GMM to PR points
# NOTE - more replicates will be more accurate, but will take longer.

gmmfit = PR.fitGMM(ptsRep, K)

# Draw clusters

bwLabel = PR.drawClusters(gmmfit, bwim, trueEdges)









