function binIm = SurfHist(X, binSz)
    if ( ~exist('binSz','var') )
        binSz = 1;
    end
    
    if ( isscalar(binSz) )
        binSz = repmat(binSz,1,2);
    end

    dataRange = [min(X,[],1); max(X,[],1)];
    dataSize = diff(dataRange,1) + binSz;
    
    totalSize = ceil(dataSize ./ binSz);
    binIm = zeros(totalSize([2 1]));
    
    shiftData = X-repmat(dataRange(1,:)-binSz,size(X,1),1);
    binData = round(shiftData./repmat(binSz,size(X,1),1));
    
    [uqBins,~,ic] = unique(binData(:,[2 1]),'rows');
    binCell = num2cell(uqBins,1);
    
    uqIdx = sub2ind(size(binIm), binCell{:});
    
    dataMap = sort(ic);
    repPts = [1;diff(dataMap)];
    uqCounts = diff([find(repPts);length(dataMap)+1]);
    
    binIm(uqIdx) = uqCounts;
    
    binRange = cell(1,length(binSz));
    for i=1:length(binSz)
        startBin = dataRange(1,i)-binSz(i)/2;
        endBin = dataRange(2,i)+binSz(i)/2;
        binRange{i} = startBin:binSz(i):(endBin-binSz(i)/2);
    end
    
    [XX,YY] = meshgrid(binRange{:});
    surf(XX,YY,binIm, 'EdgeColor','none');
end
